#include <p30fxxxx.h>
#include <xlcd.h>

/*External LCD functions are only defined for the following devices */
#if defined(__dsPIC30F5011__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/********************************************************************************************
    This file provides the delay routines required XLCD operation.
	The following are the delay routines provided: 1. Delay18Tcy   - Delay for 18Tcy
                                                   2. DelayXLCD    - Delay for atleast 5msec 
                                                   3. Delay100XLCD - Delay for 100Tcy
                                                   4. DelayPORXLCD - Delay for atleast 15msec
    The loop counts used in these routines needs to be changed based on the 
    exact clock frequency.
********************************************************************************************/

void Delay18Tcy(void)   	/* provides delay for 18Tcy */
{
    int i;
    for(i=0;i<18;i++)
        asm("clrwdt");
}

void DelayPORXLCD(void) 	/* provides delay for atleast 15msec */
{
    int i;
    for(i=0;i<18000;i++)
        asm("clrwdt");
}

void DelayXLCD(void)  		/* provides delay for atleast 5msec */
{
    int i;
    for(i=0;i<1800;i++)
        asm("clrwdt");
}

void Delay100XLCD(void)		/* provides delay for 100Tcy */
{
    int i;
    for(i=0;i<100;i++)
        asm("clrwdt");
}

#endif
